////////////////////////////////////////////////////////////////////
//
//	Class QuickProdStatsList
//
//		Utility to assist evaluations of clusters
//
//
package Alkindi.Services.InternalData;

import java.util.Arrays;
import java.util.HashMap;
import Alkindi.Data.Product;

/* 
$Header: QuickProdStatsList.java, 14, 4/26/01 2:36:58 PM, Schwartz, Joe$
$Log: 
 14   Alkindi Development1.13        4/26/01 2:36:58 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 13   Alkindi Development1.12        4/26/01 1:46:07 PM   Schwartz, Joe   Moved
      to new package.
 12   Alkindi Development1.11        1/26/01 5:48:30 PM   Schwartz, Joe  
      Improving efficiency.
 11   Alkindi Development1.10        1/2/01 3:37:07 PM    Schwartz, Joe   Added
      some documentation. Made value sorting in getTopNStats() more explicit.
 10   Alkindi Development1.9         12/28/00 1:07:27 PM  Schwartz, Joe   Added
      Version Control header info.
 9    Alkindi Development1.8         12/26/00 6:57:15 PM  Schwartz, Joe   
 8    Alkindi Development1.7         12/18/00 12:06:25 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 7    Alkindi Development1.6         12/15/00 6:20:38 PM  Schwartz, Joe  
      Changed internal storage to HashMap of Products / QPS.
 6    Alkindi Development1.5         12/5/00 1:21:18 PM   Schwartz, Joe   
 5    Alkindi Development1.4         12/3/00 11:40:36 PM  Schwartz, Joe  
      Commented out a debug line.
 4    Alkindi Development1.3         12/3/00 7:51:18 PM   Schwartz, Joe   
 3    Alkindi Development1.2         12/3/00 5:45:19 PM   Schwartz, Joe  
      Changed QuickProdStatsList to use HashMap
 2    Alkindi Development1.1         12/2/00 1:01:54 PM   Schwartz, Joe   
 1    Alkindi Development1.0         10/27/00 3:44:30 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This represents a list of QuickProdStats objects using Product objects as keys.
 */
public class QuickProdStatsList implements Cloneable 
{
	private static final QuickProdStatsList qplInstance = new QuickProdStatsList();
	private HashMap statsMap;
	
	/**
	 * Adds a Product/QuickProdStats pair to the internal map.
	 * @roseuid 3A29190F005D
	 */
	public void add(Product key, QuickProdStats itemToAdd) 
	{
		statsMap.put(key, itemToAdd);
	}
	
	/**
	 * @roseuid 3A2AC59C0177
	 */
	public void clear() 
	{
		statsMap.clear();
	}
	
	/**
	 * Retrieves the QuickProdStats object mapped to the given Product.
	 * @roseuid 3A29191200DA
	 */
	public QuickProdStats get(Product key) 
	{
		return (QuickProdStats) statsMap.get(key);
	}
	
	/**
	 * @roseuid 3A719F200167
	 */
	public static final QuickProdStatsList getInstance() 
	{
		try {
			QuickProdStatsList newQpl = (QuickProdStatsList)qplInstance.clone();
			newQpl.statsMap = (HashMap)qplInstance.statsMap.clone();
			return newQpl;
		}
		catch(CloneNotSupportedException cne) {
			return null;
		}
	}
	
	/**
	 * Retrieves the statistics for the Top N in the list, sorted by their natural ordering.
	 * @roseuid 3A291980008C
	 */
	public QuickProdStats getTopNStats(int numToCount) 
	{
		QuickProdStats retStats = QuickProdStats.getInstance();
		//	Sort the values of the internal HashMap, which are the
		//	QuickProdStats. See QuickProdStats.compareTo() for a description
		//	of their natural ordering.
		//
		Object[] sortedStats = statsMap.values().toArray();
		Arrays.sort(sortedStats);
						
		int lastIdx = Math.max(0, sortedStats.length - numToCount);
		
//		System.out.println("Sorted products by score1: lastIdx=" + lastIdx);
		for (int statIdx = sortedStats.length; --statIdx >= lastIdx; ) {
			retStats.addFrom((QuickProdStats)sortedStats[statIdx]);
			QuickProdStats item = (QuickProdStats)sortedStats[statIdx];
//			System.out.print("			prod id=" + + " score1= " + item.getScore1());
//			System.out.println(item.toString());
		}
		return retStats;
	}
	
	/**
	 * @roseuid 3A719EF70196
	 */
	private QuickProdStatsList() 
	{
		statsMap = new HashMap();
	}
}
